<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (! Schema::hasTable('mosque_committee_members')) {
            return;
        }

        Schema::table('mosque_committee_members', function (Blueprint $table) {
            if (! Schema::hasColumn('mosque_committee_members', 'whatsapp_number')) {
                $table->string('whatsapp_number', 50)->nullable()->after('phone');
            }
            if (! Schema::hasColumn('mosque_committee_members', 'whatsapp_same_as_phone')) {
                $table->boolean('whatsapp_same_as_phone')->default(false)->after('whatsapp_number');
            }
        });
    }

    public function down(): void
    {
        if (! Schema::hasTable('mosque_committee_members')) {
            return;
        }

        Schema::table('mosque_committee_members', function (Blueprint $table) {
            if (Schema::hasColumn('mosque_committee_members', 'whatsapp_same_as_phone')) {
                $table->dropColumn('whatsapp_same_as_phone');
            }
            if (Schema::hasColumn('mosque_committee_members', 'whatsapp_number')) {
                $table->dropColumn('whatsapp_number');
            }
        });
    }
};

