<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_floors')) {
            return;
        }

        Schema::create('ten_floors', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('building_id')->index();
            $table->string('name_or_number')->index();
            $table->unsignedInteger('sort_order')->default(0)->index();
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['business_id', 'building_id', 'sort_order'], 'ten_floors_biz_bld_sort_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

