<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_rooms')) {
            return;
        }

        Schema::create('ten_rooms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('floor_id')->index();
            $table->string('code')->index();
            $table->enum('type', ['room', 'apartment', 'ward'])->default('room')->index();
            $table->unsignedInteger('capacity_total')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->unique(['business_id', 'floor_id', 'code'], 'ten_rooms_biz_floor_code_uq');
            $table->index(['business_id', 'floor_id', 'type'], 'ten_rooms_biz_floor_type_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

