<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_seats')) {
            return;
        }

        Schema::create('ten_seats', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('room_id')->index();
            $table->string('code')->index();
            $table->unsignedInteger('capacity')->default(1);
            $table->enum('status', ['available', 'held', 'occupied', 'maintenance'])->default('available')->index();
            $table->date('leaving_on')->nullable()->index();
            $table->text('notes')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->unique(['business_id', 'room_id', 'code'], 'ten_seats_biz_room_code_uq');
            $table->index(['business_id', 'room_id', 'status'], 'ten_seats_biz_room_status_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

