<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_tenants')) {
            return;
        }

        Schema::create('ten_tenants', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedInteger('user_id')->nullable()->index();
            $table->string('full_name')->index();
            $table->string('phone')->index();
            $table->string('whatsapp')->nullable()->index();
            $table->string('email')->nullable()->index();
            $table->string('home_country')->nullable();
            $table->text('present_address')->nullable();
            $table->text('permanent_address')->nullable();
            $table->date('dob')->nullable()->index();
            $table->string('marital_status')->nullable()->index();
            $table->string('nid_no')->nullable()->index();
            $table->string('passport_no')->nullable()->index();
            $table->date('passport_issue_date')->nullable();
            $table->date('passport_expiry_date')->nullable();
            $table->string('photo_path')->nullable();
            $table->json('attachments')->nullable();
            $table->json('form_data')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['business_id', 'phone'], 'ten_tenants_biz_phone_idx');
            $table->index(['business_id', 'nid_no'], 'ten_tenants_biz_nid_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

