<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_allocations')) {
            return;
        }

        Schema::create('ten_allocations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('seat_id')->index();
            $table->unsignedBigInteger('tenant_id')->index();
            $table->date('start_date')->index();
            $table->date('end_date')->nullable()->index();
            $table->enum('status', ['pending', 'active', 'ended'])->default('active')->index();
            $table->decimal('rent_amount', 15, 4)->default(0);
            $table->enum('billing_cycle', ['monthly', 'yearly'])->default('monthly')->index();
            $table->date('next_bill_on')->index();
            $table->decimal('security_deposit', 15, 4)->nullable();
            $table->text('note')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['business_id', 'seat_id', 'status'], 'ten_alloc_biz_seat_status_idx');
            $table->index(['business_id', 'tenant_id', 'status'], 'ten_alloc_biz_tenant_status_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

