<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_bills')) {
            return;
        }

        Schema::create('ten_bills', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('allocation_id')->index();
            $table->date('period_from')->index();
            $table->date('period_to')->index();
            $table->decimal('amount', 15, 4)->default(0);
            $table->decimal('tax', 15, 4)->nullable();
            $table->decimal('discount', 15, 4)->nullable();
            $table->enum('status', ['unpaid', 'partially_paid', 'paid'])->default('unpaid')->index();
            $table->unsignedBigInteger('pos_invoice_id')->nullable()->index();
            $table->date('generated_on')->index();
            $table->timestamps();
            $table->softDeletes();

            $table->unique(['business_id', 'allocation_id', 'period_from', 'period_to'], 'ten_bills_idempotent_uq');
            $table->index(['business_id', 'status', 'generated_on'], 'ten_bills_biz_status_date_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

