<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_requests')) {
            return;
        }

        Schema::create('ten_requests', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->unsignedBigInteger('seat_id')->nullable()->index();
            $table->string('token', 64)->index();
            $table->string('requested_by_name')->nullable();
            $table->string('phone')->index();
            $table->string('prefer_period')->nullable();
            $table->text('notes')->nullable();
            $table->enum('status', ['pending', 'approved', 'declined'])->default('pending')->index();
            $table->json('audit')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->unique(['business_id', 'token'], 'ten_requests_biz_token_uq');
            $table->index(['business_id', 'status', 'created_at'], 'ten_requests_biz_status_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

