<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('ten_cases')) {
            return;
        }

        Schema::create('ten_cases', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('business_id')->index();
            $table->string('tenant_key', 128)->index();
            $table->string('title')->index();
            $table->longText('details')->nullable();
            $table->enum('severity', ['low', 'medium', 'high', 'critical'])->default('low')->index();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->json('attachments')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->index(['business_id', 'tenant_key'], 'ten_cases_biz_key_idx');
        });
    }

    public function down(): void
    {
        // Non-destructive: do not drop table.
    }
};

