<?php

namespace Modules\Mosque\Database\Seeders;

use App\Business;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\MosqueFinanceCategory;

class MosqueFinanceCategoriesSeeder extends Seeder
{
    private const DEFAULTS = [
        'income' => [
            'Donations',
            'Membership fees',
            'Event income',
            'Hall/property rent',
            'Sales',
            'Other income',
        ],
        'expense' => [
            'Salary',
            'Utilities',
            'Maintenance',
            'Charity',
            'Office/Admin',
            'Purchases',
            'Event Expense',
        ],
    ];

    public function run(): void
    {
        if (! Schema::hasTable('mosque_finance_categories')) {
            return;
        }

        $businessIds = Business::query()->pluck('id');

        foreach ($businessIds as $businessId) {
            foreach (self::DEFAULTS as $type => $names) {
                foreach ($names as $index => $name) {
                    MosqueFinanceCategory::query()->firstOrCreate(
                        ['business_id' => $businessId, 'type' => $type, 'name' => $name],
                        ['active' => true, 'sort_order' => ($index + 1)]
                    );
                }
            }
        }
    }
}
