<?php

namespace Modules\Mosque\Database\Seeders;

use App\Business;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\MosqueMembershipPlan;

class MosqueMembershipPlansSeeder extends Seeder
{
    public function run(): void
    {
        if (! Schema::hasTable('mosque_membership_plans')) {
            return;
        }

        if (! class_exists(Business::class)) {
            return;
        }

        $defaults = [
            ['name' => 'Monthly Basic', 'type' => 'monthly', 'amount' => 0],
            ['name' => 'Monthly Standard', 'type' => 'monthly', 'amount' => 0],
            ['name' => 'Monthly Premium', 'type' => 'monthly', 'amount' => 0],
            ['name' => 'Yearly Standard', 'type' => 'yearly', 'amount' => 0],
            ['name' => 'Yearly Premium', 'type' => 'yearly', 'amount' => 0],
        ];

        $businessIds = Business::query()->pluck('id');

        foreach ($businessIds as $businessId) {
            foreach ($defaults as $plan) {
                MosqueMembershipPlan::query()->firstOrCreate([
                    'business_id' => $businessId,
                    'name' => $plan['name'],
                    'type' => $plan['type'],
                ], [
                    'amount' => $plan['amount'],
                    'active' => true,
                ]);
            }
        }
    }
}

