<?php

namespace Modules\Mosque\Database\Seeders;

use App\Business;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class MosquePermissionsSeeder extends Seeder
{
    private const PERMISSIONS = [
        'mosque.members.manage',
        'mosque.subscriptions.manage',
        'mosque.membership.cancel',
        'mosque.membership.reactivate',
        'mosque.membership.delete',
        'mosque.donations.manage',
        'mosque.pledges.view',
        'mosque.pledges.create',
        'mosque.pledges.edit',
        'mosque.pledges.fulfill',
        'mosque.pledges.remind',
        'mosque.pledges.delete',
        'mosque.pledges.reports',
        'mosque.finance.income',
        'mosque.finance.expense',
        'mosque.finance.reports',
        'mosque.committee.manage',
        'mosque.staff.manage',
        'mosque.marriage.manage',
        'mosque.death.manage',
        'mosque.assets.manage',
        'mosque.events.manage',
        'mosque.audit.view',
        'mosque.manage',
        'mosque.license.manage',
        'mosque.finance.bank.manage',
        'mosque.finance.bank.transfer',
        'mosque.finance.cashout.manage',
        'mosque.tenancy.view',
        'mosque.tenancy.edit',
        'mosque.tenancy.allocate',
        'mosque.tenancy.billing.run',
        'mosque.tenancy.requests.manage',
        'mosque.tenancy.cases.view',
        'mosque.tenancy.settings.manage',
    ];

    public function run(): void
    {
        foreach (self::PERMISSIONS as $permissionName) {
            Permission::firstOrCreate(['name' => $permissionName, 'guard_name' => 'web']);
        }

        $businessIds = Business::query()->pluck('id');
        foreach ($businessIds as $businessId) {
            $roles = Role::query()
                ->where('business_id', $businessId)
                ->whereIn('name', ['Admin#' . $businessId, 'Mosque Manager#' . $businessId, 'Mosque Manager'])
                ->get()
                ->keyBy('id');

            // Best-effort: also grant to roles that already manage mosque assets/staff (property/HR-like roles).
            $extraRoleIds = Role::query()
                ->where('business_id', $businessId)
                ->whereHas('permissions', function ($q) {
                    $q->whereIn('name', ['mosque.assets.manage', 'mosque.staff.manage']);
                })
                ->pluck('id');

            foreach ($extraRoleIds as $rid) {
                $role = Role::query()->where('business_id', $businessId)->find($rid);
                if ($role) {
                    $roles[$role->id] = $role;
                }
            }

            foreach ($roles as $role) {
                if (! empty($role)) {
                    $role->givePermissionTo(self::PERMISSIONS);
                }
            }
        }
    }
}
