<?php

namespace Modules\Mosque\Database\Seeders;

use App\Business;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\MosqDonationGood;
use Modules\Mosque\Entities\MosqueSetting;

class MosquePledgesSeeder extends Seeder
{
    private const GOODS = [
        ['name' => 'Cement', 'unit' => 'bag', 'default_est_value' => 0],
        ['name' => 'Sand', 'unit' => 'ton', 'default_est_value' => 0],
        ['name' => 'Carpet', 'unit' => 'roll', 'default_est_value' => 0],
    ];

    public function run(): void
    {
        $businessIds = Business::query()->pluck('id');

        if (Schema::hasTable('mosq_donation_goods')) {
            foreach ($businessIds as $businessId) {
                foreach (self::GOODS as $row) {
                    MosqDonationGood::query()->firstOrCreate(
                        ['business_id' => $businessId, 'name' => $row['name']],
                        [
                            'unit' => $row['unit'],
                            'default_est_value' => $row['default_est_value'],
                            'is_active' => true,
                        ]
                    );
                }
            }
        }

        if (Schema::hasTable('mosque_settings')) {
            foreach ($businessIds as $businessId) {
                $settingsRow = MosqueSetting::query()->firstOrCreate(['business_id' => $businessId], ['settings' => []]);
                $settings = $settingsRow->settings ?: [];

                $settings['pledges_enabled'] = (bool) ($settings['pledges_enabled'] ?? true);
                $settings['pledges_reminder_windows'] = (string) ($settings['pledges_reminder_windows'] ?? '7,30');

                $settings['template_pledge_reminder_whatsapp'] = (string) ($settings['template_pledge_reminder_whatsapp'] ?? 'Assalamu Alaikum {{donor_name}}. Reminder: pledge {{pledge_code}} ({{type}}) due on {{due_date}}. Balance: {{balance}}. {{business_name}}');
                $settings['template_pledge_reminder_sms'] = (string) ($settings['template_pledge_reminder_sms'] ?? 'Reminder: pledge {{pledge_code}} due {{due_date}}. Balance {{balance}}. {{business_name}}');
                $settings['template_pledge_reminder_email_subject'] = (string) ($settings['template_pledge_reminder_email_subject'] ?? 'Pledge Reminder: {{pledge_code}}');
                $settings['template_pledge_reminder_email'] = (string) ($settings['template_pledge_reminder_email'] ?? "Dear {{donor_name}},\n\nThis is a reminder for pledge {{pledge_code}} ({{type}}) due on {{due_date}}.\nRemaining balance: {{balance}}.\n\n{{business_name}}\n");

                $settingsRow->settings = $settings;
                $settingsRow->save();
            }
        }
    }
}

