<?php

namespace Modules\Mosque\Database\Seeders;

use App\Business;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\MosqueStaffRole;

class MosqueStaffRolesSeeder extends Seeder
{
    private const DEFAULTS = [
        ['name' => 'Imam', 'sort_order' => 10],
        ['name' => 'Muazzin', 'sort_order' => 20],
        ['name' => 'Khateeb', 'sort_order' => 30],
        ['name' => 'Teacher', 'sort_order' => 40],
        ['name' => 'Volunteer', 'sort_order' => 50],
        ['name' => 'Office Staff', 'sort_order' => 60],
    ];

    public function run(): void
    {
        if (! Schema::hasTable('mosque_staff_roles')) {
            return;
        }

        $businessIds = Business::query()->pluck('id');

        foreach ($businessIds as $businessId) {
            foreach (self::DEFAULTS as $row) {
                MosqueStaffRole::query()->firstOrCreate(
                    [
                        'business_id' => $businessId,
                        'name' => $row['name'],
                    ],
                    [
                        'active' => true,
                        'sort_order' => (int) $row['sort_order'],
                    ]
                );
            }
        }
    }
}

