<?php

namespace Modules\Mosque\Database\Seeders;

use App\Business;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\TenBuilding;
use Modules\Mosque\Entities\TenFloor;
use Modules\Mosque\Entities\TenRoom;
use Modules\Mosque\Entities\TenSeat;

class TenancyDemoSeeder extends Seeder
{
    public function run(): void
    {
        if (! Schema::hasTable('ten_buildings') || ! Schema::hasTable('ten_floors') || ! Schema::hasTable('ten_rooms') || ! Schema::hasTable('ten_seats')) {
            return;
        }

        $businessIds = Business::query()->pluck('id');

        foreach ($businessIds as $businessId) {
            $exists = TenBuilding::query()->where('business_id', $businessId)->exists();
            if ($exists) {
                continue;
            }

            $building = TenBuilding::query()->create([
                'business_id' => $businessId,
                'name' => 'Main Building',
                'address' => null,
                'notes' => 'Demo building (delete if not needed).',
            ]);

            foreach ([['name' => 'Floor 1', 'order' => 1], ['name' => 'Floor 2', 'order' => 2]] as $f) {
                $floor = TenFloor::query()->create([
                    'business_id' => $businessId,
                    'building_id' => $building->id,
                    'name_or_number' => $f['name'],
                    'sort_order' => $f['order'],
                    'notes' => null,
                ]);

                $room = TenRoom::query()->create([
                    'business_id' => $businessId,
                    'floor_id' => $floor->id,
                    'code' => $f['order'] === 1 ? 'A' : 'B',
                    'type' => 'room',
                    'capacity_total' => null,
                    'notes' => null,
                ]);

                for ($i = 1; $i <= 12; $i++) {
                    TenSeat::query()->create([
                        'business_id' => $businessId,
                        'room_id' => $room->id,
                        'code' => 'S'.$i,
                        'capacity' => 1,
                        'status' => 'available',
                        'leaving_on' => null,
                        'notes' => null,
                    ]);
                }
            }
        }
    }
}

