<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class MosqPledge extends Model
{
    protected $table = 'mosq_pledges';

    protected $fillable = [
        'business_id',
        'location_id',
        'pledge_code',
        'donor_contact_id',
        'donor_name',
        'donor_phone',
        'donor_email',
        'type',
        'due_date',
        'recurrence',
        'est_total_value',
        'currency',
        'status',
        'notes',
        'created_by',
    ];

    public function fulfillments(): HasMany
    {
        return $this->hasMany(MosqPledgeFulfillment::class, 'pledge_id');
    }

    public function items(): HasMany
    {
        return $this->hasMany(MosqPledgeItem::class, 'pledge_id');
    }
}
