<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class MosqPledgeFulfillment extends Model
{
    protected $table = 'mosq_pledge_fulfillments';

    protected $fillable = [
        'pledge_id',
        'date',
        'channel',
        'amount_cash',
        'goods_name',
        'unit',
        'qty',
        'est_value',
        'remarks',
        'created_by',
    ];

    public function pledge(): BelongsTo
    {
        return $this->belongsTo(MosqPledge::class, 'pledge_id');
    }
}
