<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueAsset extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_assets';

    protected $fillable = [
        'business_id',
        'name',
        'tag_no',
        'acquired_on',
        'value',
        'status',
        'notes',
    ];

    protected $casts = [
        'acquired_on' => 'date',
    ];
}

