<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueBankCashoutRequest extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_bank_cashout_requests';

    protected $guarded = ['id'];

    protected $casts = [
        'amount' => 'float',
        'request_date' => 'date',
        'requested_at' => 'datetime',
        'approved_at' => 'datetime',
        'rejected_at' => 'datetime',
    ];
}

