<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueCommittee extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_committees';

    protected $fillable = [
        'business_id',
        'name',
        'term_start',
        'term_end',
        'notes',
    ];

    protected $casts = [
        'term_start' => 'date',
        'term_end' => 'date',
    ];
}

