<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueDonation extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_donations';

    protected $fillable = [
        'business_id',
        'donor_id',
        'type',
        'channel',
        'amount',
        'date',
        'anonymous',
        'fund_tag',
        'receipt_no',
        'notes',
    ];

    protected $casts = [
        'date' => 'date',
        'anonymous' => 'boolean',
    ];
}

