<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueDonorProfile extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_donor_profiles';

    protected $fillable = [
        'business_id',
        'name',
        'phone',
        'whatsapp_number',
        'whatsapp_same_as_phone',
        'email',
        'address',
        'tax_id',
        'notes',
    ];

    protected $casts = [
        'whatsapp_same_as_phone' => 'boolean',
    ];
}
