<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueEvent extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_events';

    protected $fillable = [
        'business_id',
        'name',
        'type',
        'start_date',
        'end_date',
        'notes',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
    ];
}

