<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueFinanceEntry extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_finance_entries';

    protected $fillable = [
        'business_id',
        'location_id',
        'type',
        'category_id',
        'amount',
        'entry_date',
        'ref_module',
        'ref_id',
        'fund_tag',
        'note',
        'created_by',
    ];

    protected $casts = [
        'entry_date' => 'date',
    ];
}

