<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueLeaveType extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_leave_types';

    protected $fillable = [
        'business_id',
        'name',
        'is_paid',
        'active',
        'created_by',
    ];

    protected $casts = [
        'is_paid' => 'boolean',
        'active' => 'boolean',
        'deleted_at' => 'datetime',
    ];
}

