<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueMarriage extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_marriages';

    protected $fillable = [
        'business_id',
        'bride',
        'groom',
        'wali',
        'witnesses',
        'mahr',
        'date',
        'certificate_no',
        'notes',
    ];

    protected $casts = [
        'date' => 'date',
        'witnesses' => 'array',
    ];
}

