<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueMember extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_members';

    protected $fillable = [
        'business_id',
        'location_id',
        'name',
        'phone',
        'whatsapp_number',
        'whatsapp_same_as_phone',
        'email',
        'address',
        'status',
        'photo_path',
        'notes',
    ];

    protected $casts = [
        'whatsapp_same_as_phone' => 'boolean',
    ];
}
