<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueMinute extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_minutes';

    protected $fillable = [
        'business_id',
        'committee_id',
        'minute_no',
        'date',
        'decisions',
        'attachments',
    ];

    protected $casts = [
        'date' => 'date',
        'attachments' => 'array',
    ];
}

