<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosquePayslip extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_payslips';

    protected $fillable = [
        'business_id',
        'staff_id',
        'period_ym',
        'gross',
        'bonus_amount',
        'bonus_reason',
        'bonus_lines',
        'deduction_amount',
        'deduction_lines',
        'net',
        'paid_amount',
        'payment_method',
        'payment_ref_no',
        'payment_note',
        'paid_on',
        'note',
    ];

    protected $casts = [
        'paid_on' => 'date',
        'bonus_lines' => 'array',
        'deduction_lines' => 'array',
    ];
}
