<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueRental extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_rentals';

    protected $fillable = [
        'business_id',
        'property_id',
        'tenant_name',
        'from_date',
        'to_date',
        'rent_amount',
        'paid_amount',
        'status',
    ];

    protected $casts = [
        'from_date' => 'date',
        'to_date' => 'date',
    ];
}

