<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueStaffLeave extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_staff_leaves';

    protected $fillable = [
        'business_id',
        'staff_id',
        'leave_type_id',
        'start_date',
        'end_date',
        'status',
        'reason',
        'approved_by',
        'approved_at',
        'created_by',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'approved_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];
}

