<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MosqueStaffRole extends Model
{
    use SoftDeletes;

    protected $table = 'mosque_staff_roles';

    protected $fillable = [
        'business_id',
        'name',
        'active',
        'sort_order',
    ];

    protected $casts = [
        'active' => 'boolean',
        'sort_order' => 'integer',
    ];
}

