<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenAllocation extends Model
{
    use SoftDeletes;

    protected $table = 'ten_allocations';

    protected $fillable = [
        'business_id',
        'seat_id',
        'tenant_id',
        'start_date',
        'end_date',
        'status',
        'rent_amount',
        'billing_cycle',
        'next_bill_on',
        'security_deposit',
        'note',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'next_bill_on' => 'date',
    ];

    public function seat()
    {
        return $this->belongsTo(TenSeat::class, 'seat_id');
    }

    public function tenant()
    {
        return $this->belongsTo(TenTenant::class, 'tenant_id');
    }

    public function bills()
    {
        return $this->hasMany(TenBill::class, 'allocation_id');
    }
}

