<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenBill extends Model
{
    use SoftDeletes;

    protected $table = 'ten_bills';

    protected $fillable = [
        'business_id',
        'allocation_id',
        'period_from',
        'period_to',
        'amount',
        'tax',
        'discount',
        'status',
        'pos_invoice_id',
        'generated_on',
    ];

    protected $casts = [
        'period_from' => 'date',
        'period_to' => 'date',
        'generated_on' => 'date',
    ];

    public function allocation()
    {
        return $this->belongsTo(TenAllocation::class, 'allocation_id');
    }
}

