<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenBuilding extends Model
{
    use SoftDeletes;

    protected $table = 'ten_buildings';

    protected $fillable = [
        'business_id',
        'name',
        'address',
        'notes',
    ];

    public function floors()
    {
        return $this->hasMany(TenFloor::class, 'building_id');
    }
}

