<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenCase extends Model
{
    use SoftDeletes;

    protected $table = 'ten_cases';

    protected $fillable = [
        'business_id',
        'tenant_key',
        'title',
        'details',
        'severity',
        'created_by',
        'attachments',
    ];

    protected $casts = [
        'attachments' => 'array',
    ];
}

