<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenFloor extends Model
{
    use SoftDeletes;

    protected $table = 'ten_floors';

    protected $fillable = [
        'business_id',
        'building_id',
        'name_or_number',
        'sort_order',
        'notes',
    ];

    public function building()
    {
        return $this->belongsTo(TenBuilding::class, 'building_id');
    }

    public function rooms()
    {
        return $this->hasMany(TenRoom::class, 'floor_id');
    }
}

