<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenRequest extends Model
{
    use SoftDeletes;

    protected $table = 'ten_requests';

    protected $fillable = [
        'business_id',
        'seat_id',
        'token',
        'requested_by_name',
        'phone',
        'prefer_period',
        'notes',
        'status',
        'audit',
    ];

    protected $casts = [
        'audit' => 'array',
    ];

    public function seat()
    {
        return $this->belongsTo(TenSeat::class, 'seat_id');
    }
}

