<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenRoom extends Model
{
    use SoftDeletes;

    protected $table = 'ten_rooms';

    protected $fillable = [
        'business_id',
        'floor_id',
        'code',
        'type',
        'capacity_total',
        'notes',
    ];

    public function floor()
    {
        return $this->belongsTo(TenFloor::class, 'floor_id');
    }

    public function seats()
    {
        return $this->hasMany(TenSeat::class, 'room_id');
    }
}

