<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenSeat extends Model
{
    use SoftDeletes;

    protected $table = 'ten_seats';

    protected $fillable = [
        'business_id',
        'room_id',
        'code',
        'capacity',
        'status',
        'leaving_on',
        'notes',
    ];

    protected $casts = [
        'leaving_on' => 'date',
    ];

    public function room()
    {
        return $this->belongsTo(TenRoom::class, 'room_id');
    }

    public function allocations()
    {
        return $this->hasMany(TenAllocation::class, 'seat_id');
    }

    public function activeAllocation()
    {
        return $this->hasOne(TenAllocation::class, 'seat_id')->where('status', 'active');
    }
}

