<?php

namespace Modules\Mosque\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TenTenant extends Model
{
    use SoftDeletes;

    protected $table = 'ten_tenants';

    protected $fillable = [
        'business_id',
        'user_id',
        'full_name',
        'phone',
        'whatsapp',
        'email',
        'home_country',
        'present_address',
        'permanent_address',
        'dob',
        'marital_status',
        'nid_no',
        'passport_no',
        'passport_issue_date',
        'passport_expiry_date',
        'photo_path',
        'attachments',
        'form_data',
    ];

    protected $casts = [
        'dob' => 'date',
        'passport_issue_date' => 'date',
        'passport_expiry_date' => 'date',
        'attachments' => 'array',
        'form_data' => 'array',
    ];

    public function allocations()
    {
        return $this->hasMany(TenAllocation::class, 'tenant_id');
    }
}

