<?php

namespace Modules\Mosque\Http\Controllers;

use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Modules\Mosque\Entities\MosqueLicense;
use Modules\Mosque\Utils\MosqueAuditUtil;

class ActivationController extends Controller
{
    public function index()
    {
        return view('mosque::activate');
    }

    public function store()
    {
        request()->validate([
            'username' => 'required|string',
            'license' => 'required|string',
        ]);

        $username = trim((string) request()->input('username'));
        $license = trim((string) request()->input('license'));

        if ($username !== $license) {
            return redirect()
                ->back()
                ->withInput()
                ->with('status', ['success' => 0, 'msg' => __('mosque::mosque.activation_mismatch')]);
        }

        $businessId = request()->session()->get('user.business_id');
        if (empty($businessId)) {
            abort(403, 'Unauthorized action.');
        }

        $payload = [
            'username_encrypted' => Crypt::encryptString($username),
            'license_encrypted' => Crypt::encryptString($license),
            'activated_at' => now(),
            'created_by' => auth()->id(),
        ];

        $licenseRow = null;
        DB::transaction(function () use ($businessId, $payload, &$licenseRow) {
            $licenseRow = MosqueLicense::query()->updateOrCreate(
                ['business_id' => $businessId],
                array_merge($payload, ['business_id' => $businessId])
            );
        });

        MosqueAuditUtil::log((int) $businessId, 'activate', 'license', $licenseRow?->id, ['by' => auth()->id()]);

        return redirect()
            ->route('mosque.dashboard')
            ->with('status', ['success' => 1, 'msg' => __('mosque::mosque.activation_success')]);
    }
}
