<?php

namespace Modules\Mosque\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Mosque\Entities\MosqueAuditLog;
use Yajra\DataTables\Facades\DataTables;

class AuditController extends Controller
{
    private function businessId(): int
    {
        $businessId = (int) request()->session()->get('user.business_id');
        if (empty($businessId)) {
            abort(403, 'Unauthorized action.');
        }

        return $businessId;
    }

    private function ensurePermission(): void
    {
        if (! auth()->user()->can('mosque.audit.view')) {
            abort(403, 'Unauthorized action.');
        }
    }

    public function index()
    {
        $this->ensurePermission();

        return view('mosque::audit.index');
    }

    public function data(Request $request)
    {
        $this->ensurePermission();

        $businessId = $this->businessId();

        $query = MosqueAuditLog::query()
            ->where('business_id', $businessId)
            ->select(['id', 'created_at', 'actor_id', 'action', 'entity', 'entity_id', 'ip']);

        if (! empty($request->input('start_date')) && ! empty($request->input('end_date'))) {
            $query->whereDate('created_at', '>=', $request->input('start_date'))
                ->whereDate('created_at', '<=', $request->input('end_date'));
        }

        if (! empty($request->input('action'))) {
            $query->where('action', $request->input('action'));
        }

        if (! empty($request->input('entity'))) {
            $query->where('entity', $request->input('entity'));
        }

        return DataTables::of($query)
            ->editColumn('created_at', function ($row) {
                return ! empty($row->created_at) ? $row->created_at->format('Y-m-d H:i') : '';
            })
            ->make(true);
    }
}

