<?php

namespace Modules\Mosque\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class DeathReportsController extends Controller
{
    private function businessId(): int
    {
        $businessId = (int) request()->session()->get('user.business_id');
        if (empty($businessId)) {
            abort(403, 'Unauthorized action.');
        }

        return $businessId;
    }

    private function ensurePermission(): void
    {
        if (! auth()->user()->can('mosque.death.manage')) {
            abort(403, 'Unauthorized action.');
        }
    }

    public function index()
    {
        $this->ensurePermission();

        return view('mosque::death.reports');
    }

    public function yearlyData(Request $request)
    {
        $this->ensurePermission();
        $businessId = $this->businessId();

        $query = DB::table('mosque_deaths as d')
            ->where('d.business_id', $businessId)
            ->whereNull('d.deleted_at')
            ->select([
                DB::raw('YEAR(d.date) as year'),
                DB::raw('COUNT(d.id) as deaths_count'),
                DB::raw('COUNT(DISTINCT COALESCE(NULLIF(d.burial_place, ""), "Unknown")) as burial_places_count'),
            ])
            ->groupBy(DB::raw('YEAR(d.date)'));

        if (! empty($request->input('year'))) {
            $query->whereYear('d.date', (int) $request->input('year'));
        }
        if (! empty($request->input('start_date')) && ! empty($request->input('end_date'))) {
            $query->whereDate('d.date', '>=', $request->input('start_date'))
                ->whereDate('d.date', '<=', $request->input('end_date'));
        }

        return DataTables::of($query)->make(true);
    }
}
