<?php

namespace Modules\Mosque\Http\Controllers;

use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;
use Modules\Mosque\Entities\MosqueProfile;

class LogoController extends Controller
{
    public function show(string $filename)
    {
        $businessId = (int) request()->session()->get('user.business_id');
        if (empty($businessId)) {
            abort(403, 'Unauthorized action.');
        }

        if (! Schema::hasTable('mosque_profiles')) {
            abort(404);
        }

        $profile = MosqueProfile::query()->where('business_id', $businessId)->first();
        if (empty($profile) || empty($profile->logo) || (string) $profile->logo !== (string) $filename) {
            abort(404);
        }

        $relativePath = 'mosque_logos/'.basename((string) $filename);
        $diskDefault = (string) config('filesystems.default');
        $diskCandidates = array_values(array_unique(['public', $diskDefault]));

        foreach ($diskCandidates as $disk) {
            try {
                if (Storage::disk($disk)->exists($relativePath)) {
                    $path = Storage::disk($disk)->path($relativePath);
                    if (! empty($path) && File::exists($path)) {
                        return response()->file($path, [
                            // Make sure newly uploaded logos appear immediately.
                            'Cache-Control' => 'no-store, no-cache, must-revalidate, max-age=0',
                        ]);
                    }
                }
            } catch (\Throwable $e) {
                // ignore and try next disk
            }
        }

        // Backward-compatible fallbacks (some setups store uploads directly in public/uploads).
        $publicCandidates = [
            public_path('uploads/'.$relativePath),
            public_path('storage/'.$relativePath),
        ];
        foreach ($publicCandidates as $path) {
            try {
                if (! empty($path) && File::exists($path)) {
                    return response()->file($path, [
                        'Cache-Control' => 'no-store, no-cache, must-revalidate, max-age=0',
                    ]);
                }
            } catch (\Throwable $e) {
                // ignore and try next path
            }
        }

        abort(404);
    }
}
