<?php

namespace Modules\Mosque\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class MarriageReportsController extends Controller
{
    private function businessId(): int
    {
        $businessId = (int) request()->session()->get('user.business_id');
        if (empty($businessId)) {
            abort(403, 'Unauthorized action.');
        }

        return $businessId;
    }

    private function ensurePermission(): void
    {
        if (! auth()->user()->can('mosque.marriage.manage')) {
            abort(403, 'Unauthorized action.');
        }
    }

    public function index()
    {
        $this->ensurePermission();

        return view('mosque::marriage.reports');
    }

    public function yearlyData(Request $request)
    {
        $this->ensurePermission();
        $businessId = $this->businessId();

        $query = DB::table('mosque_marriages as m')
            ->where('m.business_id', $businessId)
            ->whereNull('m.deleted_at')
            ->select([
                DB::raw('YEAR(m.date) as year'),
                DB::raw('COUNT(m.id) as marriages_count'),
                DB::raw('SUM(CASE WHEN m.mahr IS NULL OR m.mahr = "" THEN 0 ELSE 1 END) as mahr_count'),
            ])
            ->groupBy(DB::raw('YEAR(m.date)'));

        if (! empty($request->input('year'))) {
            $query->whereYear('m.date', (int) $request->input('year'));
        }
        if (! empty($request->input('start_date')) && ! empty($request->input('end_date'))) {
            $query->whereDate('m.date', '>=', $request->input('start_date'))
                ->whereDate('m.date', '<=', $request->input('end_date'));
        }

        return DataTables::of($query)->make(true);
    }
}
