<?php

namespace Modules\Mosque\Http\Controllers;

use Illuminate\Routing\Controller;

class ReportsController extends Controller
{
    private function ensurePermission(): void
    {
        if (! auth()->user()->hasAnyPermission(['mosque.finance.reports', 'mosque.audit.view'])) {
            abort(403, 'Unauthorized action.');
        }
    }

    public function index()
    {
        $this->ensurePermission();

        return view('mosque::reports.index');
    }
}

