<?php

namespace Modules\Mosque\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Modules\Mosque\Entities\MosqueLicense;

class CheckMosqueLicense
{
    public function handle(Request $request, Closure $next)
    {
        $businessId = $request->session()->get('user.business_id');

        if (empty($businessId)) {
            return redirect()->action([\App\Http\Controllers\HomeController::class, 'index']);
        }

        $hasLicense = MosqueLicense::query()
            ->where('business_id', $businessId)
            ->exists();

        if (! $hasLicense) {
            return redirect()->route('mosque.activate');
        }

        return $next($request);
    }
}

