<?php

namespace Modules\Mosque\Http\Middleware;

use App\Utils\ModuleUtil;
use Closure;
use Illuminate\Http\Request;

class CheckMosqueSubscription
{
    public function handle(Request $request, Closure $next)
    {
        $businessId = (int) $request->session()->get('user.business_id');
        if (empty($businessId)) {
            return redirect()->action([\App\Http\Controllers\HomeController::class, 'index']);
        }

        $moduleUtil = new ModuleUtil();
        $enabled = (bool) $moduleUtil->hasThePermissionInSubscription($businessId, 'mosque_module', 'superadmin_package');

        if (! $enabled) {
            return ModuleUtil::expiredResponse(action([\App\Http\Controllers\HomeController::class, 'index']));
        }

        return $next($request);
    }
}

