<?php

namespace Modules\Mosque\Http\Middleware;

use App\Business;
use App\Currency;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\MosqueSetting;

class RefreshBusinessCurrency
{
    public function handle(Request $request, Closure $next)
    {
        if (! auth()->check()) {
            return $next($request);
        }

        $businessId = (int) $request->session()->get('user.business_id', 0);
        if (empty($businessId)) {
            $businessId = (int) (auth()->user()->business_id ?? 0);
        }
        if (empty($businessId)) {
            return $next($request);
        }

        try {
            $business = Business::with('currency')->find($businessId);
            if (empty($business) || empty($business->currency)) {
                return $next($request);
            }

            $sessionCurrencyId = (int) $request->session()->get('currency.id', 0);

            // Prefer module currency setting (if set), else fallback to business currency.
            $targetCurrencyId = (int) $business->currency_id;
            if (Schema::hasTable('mosque_settings')) {
                $row = MosqueSetting::query()->where('business_id', $businessId)->first();
                $settings = ! empty($row) ? (array) ($row->settings ?? []) : [];
                $moduleCurrencyId = (int) ($settings['currency_id'] ?? 0);
                if ($moduleCurrencyId > 0) {
                    $targetCurrencyId = $moduleCurrencyId;
                }
            }

            if ($sessionCurrencyId !== $targetCurrencyId) {
                $currency = ($targetCurrencyId === (int) $business->currency_id)
                    ? $business->currency
                    : Currency::query()->find($targetCurrencyId);

                if (! empty($currency)) {
                    $request->session()->put('currency', [
                        'id' => (int) $currency->id,
                        'code' => (string) $currency->code,
                        'symbol' => (string) $currency->symbol,
                        'thousand_separator' => (string) $currency->thousand_separator,
                        'decimal_separator' => (string) $currency->decimal_separator,
                    ]);
                }
            }

            // Keep placement synced from business (module doesn't override placement).
            $placement = (string) ($business->currency_symbol_placement ?? 'before');
            $request->session()->put('business.currency_symbol_placement', $placement);
            $request->session()->put('business.currency_id', (int) $targetCurrencyId);

            if ($request->session()->has('business_object')) {
                $request->session()->put('business_object', $business);
            }
        } catch (\Exception $e) {
            // Never block normal flows for session refresh.
        }

        return $next($request);
    }
}
